﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Weryfikacja czasu pracy na akordach</title>
		<script runat="server">

            public class PrnParams : ContextBase {

                public PrnParams(Context context)
                    : base(context) {
                    UstawMiesiąc();
                }

                YearMonth miesiąc;
                [Caption("Weryfikacja za miesiąc")]
                public YearMonth Miesiąc {
                    get { return miesiąc; }
                    set {
                        if (value == YearMonth.Empty)
                            UstawMiesiąc();
                        else
                            miesiąc = value;
                    }
                }

                void UstawMiesiąc() {
                    Date data;
                    if (Context.Contains(typeof(ActualDate)))
                        data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
                    else
                        data = Date.Today;
                    miesiąc = new YearMonth(data);
                }
            }
	
	        PrnParams pars = null;
            [Context(Required = true)]
            public PrnParams Params {
                get { return pars; }
                set { pars = value; }
            }


            FromTo okres;    
            void OnContextLoad(Object sender, EventArgs args) {
                ReportHeader1["OKRES"] = pars.Miesiąc.ToString();
                okres = pars.Miesiąc.ToFromTo();
            }

            void Grid1_BeforeRow(Object sender, RowEventArgs args) {
                PracHistoria ph = (PracHistoria)args.Row;

                Time praca = Time.Zero;
                foreach (Akord akord in ph.Pracownik.Akordy)
                    praca += new KalkulatorAkordu(akord).Pomniejszenie(okres);

                KalkulatorPlanu kp = ph.Pracownik.Czasy.KalkPlanu;
                Time norma = ph.Pracownik.Czasy.Norma(okres).Czas - ph.Pracownik.Czasy.NormaNie(okres).Czas;

                if (praca <= norma)
                    args.VisibleRow = false;
                else {
                    idNorma.EditValue = norma;
                    idPraca.EditValue = praca;
                    idRóżnica.EditValue = norma - praca;
                }
            }

            public static object Msg(object obj) {
                return obj;
            }

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UrlopyPlan" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"
				oncontextload="OnContextLoad"></ea:datacontext><cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Weryfikacja pomniejszeń za akordy|</strong>Za: <strong>%OKRES%" runat="server"></cc1:reportheader><ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"
				LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." ID="lp" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="20" DataMember="Etat.Wydzial.Kod" Caption="Nazwa działu zakładu pracy" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko i imię pracownika" NoWrap="True" runat="server"></ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Center" Caption="Norma czasu pracy"
                        Width="12" ID="idNorma" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Align="Center" Caption="Czas pracy na akordach~odnotowany"
                        Width="12" ID="idPraca" HideZero="True">
                    </ea:GridColumn>
                    <ea:GridColumn ID="idRóżnica" runat="server" Align="Center" Caption="Czas pracy na akordach~r&#243;żnica"
                        Width="12" HideZero="True">
                    </ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter></form>
	</body>
</HTML>
